/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.model;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Analog;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.util.AnalogValueProperties;
import DE.siemens.ad.logo.util.Util;
import java.io.IOException;

public class AnalogFilterParameter
extends Analog {
    private static final long serialVersionUID = 3492978602204634051L;
    private int blockSerializedDataVersion = 1;
    private transient int fFilterValue;
    private transient int fCounter;
    private transient double fTotal;
    private static final transient int AX_MIN_VALUE = Short.MIN_VALUE;
    private static final transient int AX_MAX_VALUE = Short.MAX_VALUE;
    private int fSampleNumber = 64;
    private transient int[] fParameters;

    public AnalogFilterParameter() {
    }

    public AnalogFilterParameter(Block block) {
        super(block);
    }

    public int getFilterValue() {
        return this.fFilterValue;
    }

    public double getAnalogValue(double ax) {
        if (this.fParameters.length != this.fSampleNumber) {
            this.fParameters = new int[this.fSampleNumber];
            this.fCounter = 0;
            this.fFilterValue = 0;
            this.fTotal = 0.0;
        }
        this.fAmplifiedX = (int)ax;
        ++this.fCounter;
        this.fTotal += (double)(this.fAmplifiedX - this.fParameters[this.fCounter - 1]);
        this.fParameters[this.fCounter - 1] = this.fAmplifiedX;
        this.fFilterValue = (int)(this.fTotal / (double)this.fSampleNumber);
        if (this.fCounter == this.fSampleNumber) {
            this.fCounter = 0;
        }
        this.fCurrentParameterText = this.calculateCurrentParameterText();
        this.fireParameterUpdateEvent();
        return this.fFilterValue;
    }

    public AnalogValueProperties getAmplifiedXProperties() {
        if (this.fAmplifiedXProperties == null) {
            this.fAmplifiedXProperties = new AnalogValueProperties(Short.MIN_VALUE, Short.MAX_VALUE, 1, this.fAmplifiedX, this.getDecimalPlace(), this.isAnalogValueDecimalPlacesAvailable(), "error.dialog.invalidValue", "Invalid Value");
        }
        this.fAmplifiedXProperties.setCurrentValue(this.fAmplifiedX);
        this.fAmplifiedXProperties.setDecimalPlace(this.getDecimalPlace());
        return this.fAmplifiedXProperties;
    }

    public void init(Interpreter interpreter, boolean forceReset) {
        super.init(interpreter, forceReset);
        this.fFilterValue = 0;
        this.fTotal = 0.0;
        this.fCounter = 0;
        this.fParameters = new int[this.fSampleNumber];
    }

    public String calculateCurrentParameterText() {
        StringBuffer result = new StringBuffer();
        result.append(Util.addTrailingSpaces(Integer.toString(this.fCounter), 8));
        result.append("\n");
        result.append(Util.addTrailingSpaces(Double.toString(this.fFilterValue), 8));
        this.fireParameterUpdateEvent();
        return result.toString();
    }

    public String getParameterText() {
        StringBuffer result = new StringBuffer();
        result.append("SN = ");
        result.append(this.fSampleNumber);
        return result.toString();
    }

    public Integer getSampleNumber() {
        return this.fSampleNumber;
    }

    public void setSampleNumber(Integer sampleNumber) {
        this.fSampleNumber = sampleNumber;
    }

    public int getCounter() {
        return this.fCounter;
    }

    public void write(StorableOutput dw) {
        super.write(dw);
        dw.writeInt(this.fSampleNumber);
    }

    public void read(StorableInput dr) throws IOException {
        super.read(dr);
        this.setSampleNumber(dr.readInt());
    }
}

